{{-- resources/views/talenta/employees/index.blade.php --}}
@extends('layouts.app')
@section('title','Data Karyawan (Talenta)')
@section('page-title','Data Karyawan (Talenta)')

@section('content')
<div class="bg-white p-4 rounded-xl shadow">
  @if ($errors->any())
    <div class="mb-3 bg-red-50 text-red-700 p-3 rounded">
      @foreach ($errors->all() as $e) <div>{{ $e }}</div> @endforeach
    </div>
  @endif

  <form method="GET" class="mb-4 flex flex-wrap items-center gap-2">
    <label class="text-sm text-gray-600">Limit</label>
    <input type="number" name="limit" value="{{ $limit }}" class="border rounded px-3 py-2 w-24">

    <label class="text-sm text-gray-600">Page</label>
    <input type="number" name="page" value="{{ $page }}" class="border rounded px-3 py-2 w-24">

    <label class="text-sm text-gray-600">Search</label>
    <input type="text" name="search" value="{{ $search }}" placeholder="Nama / Email" class="border rounded px-3 py-2 w-48">

    <button class="px-3 py-2 rounded bg-slate-700 text-white">Reload</button>
  </form>

  <div class="overflow-x-auto">
    <table class="min-w-full text-sm">
      <thead>
        <tr class="text-left border-b">
          <th class="py-2">User ID</th>
          <th class="py-2">First</th>
          <th class="py-2">Last</th>
          <th class="py-2">Email</th>
          <th class="py-2">Mobile</th>
          <th class="py-2">Gender</th>
          <th class="py-2">Status</th>
          <th class="py-2">Join Date</th>
        </tr>
      </thead>
      <tbody>
        @php
          $rows = $items ?? [];
        @endphp

        @forelse($rows as $it)
          @php
            $uid = $it['user_id'] ?? null;
            $p   = $it['personal'] ?? [];
            $e   = $it['employment'] ?? [];

            $fn  = $p['first_name'] ?? '';
            $ln  = $p['last_name']  ?? '';
            $em  = $p['email'] ?? '';
            $mb  = $p['mobile_phone'] ?? '';
            $gd  = $p['gender'] ?? '';
            $st  = $e['status'] ?? '';
            $jd  = $e['join_date'] ?? '';

            // filter di sisi Laravel (jika API tidak ada query search)
            $keyword = strtolower($search ?? '');
            $match = true;
            if ($keyword) {
              $match = str_contains(strtolower($fn), $keyword)
                    || str_contains(strtolower($ln), $keyword)
                    || str_contains(strtolower($em), $keyword);
            }
          @endphp

          @if($match)
            <tr class="border-b">
              <td class="py-2">{{ $uid }}</td>
              <td class="py-2">{{ $fn }}</td>
              <td class="py-2">{{ $ln }}</td>
              <td class="py-2">{{ $em }}</td>
              <td class="py-2">{{ $mb }}</td>
              <td class="py-2">{{ $gd }}</td>
              <td class="py-2">{{ $st }}</td>
              <td class="py-2">{{ $jd }}</td>
            </tr>
          @endif
        @empty
          <tr><td colspan="8" class="py-6 text-center text-gray-500">Tidak ada data.</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  @if(!empty($pagination))
    <div class="mt-4 text-xs text-gray-600">
      Page {{ $pagination['current_page'] ?? '?' }} of {{ $pagination['last_page'] ?? '?' }} |
      Total: {{ $pagination['total'] ?? '?' }}
    </div>
  @endif

  <details class="mt-6">
    <summary class="cursor-pointer text-slate-600">Lihat RAW JSON</summary>
    <pre class="text-xs bg-slate-50 p-3 rounded overflow-auto">{{ json_encode($raw ?? [], JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}</pre>
  </details>
</div>
@endsection
